/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (26/05/08)
 */   
package com.ejie.p06b.excel;

import java.text.DateFormat;
import java.util.ArrayList;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import javax.servlet.http.HttpServletRequest;

import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
//import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
//import org.apache.poi.xssf.usermodel.XSSFColor;


import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.util.P06BResources;
import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.datatype.model.P06B22T00Datatype;
import com.ejie.p06b.datatype.model.P06B24T00Datatype;
import com.ejie.p06b.datatype.model.P06B26T00Datatype;
import com.ejie.p06b.datatype.model.P06B29T00Datatype;
import com.ejie.p06b.datatype.model.P06B61T00Datatype;
import com.ejie.p06b.datatype.supramodel.InformeComunicarDGSFP2;
import com.ejie.p06b.general.P06BConstantes;



/**
 * Clase que gestiona la generacin del pdf
 */
public class P06BInformeComunicarDGSFP2PDF implements P06BIExcel {
    private static long numeroEXCEL = 0;
	
	//Todo bien --> Devuelve la ruta donde dejaremos el excel
	//Error --> 1 Error al generar el EXCEL
    public String getEXCEL(HttpServletRequest request) throws Exception {
		P06BLog.send(2,"P06BListadoExcel", "getEXCEL(...)");
		
    	P06BResources res = (P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS);

    	String idioma = (String)request.getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);	
		if (idioma == null || idioma.equals("") ){
			idioma = P06BConstantes.P06B_IDIOMA_ES; //"es"
		}
		
		numeroEXCEL=numeroEXCEL+1;
		String error="1";
		
		String excelFichero = P06BParametros.get("excel.comunicarDGSFP2")+numeroEXCEL+".excel";

//		Obtener el listado de corredores que cumplen los criterios de bsqueda
		InformeComunicarDGSFP2 informeComunicarDGSFP2 = new InformeComunicarDGSFP2();
		informeComunicarDGSFP2 = P06BCorredoresManager.getInstance().selectInformeComunicarDGSFP2(informeComunicarDGSFP2);
		ArrayList<P06B20T00Datatype> datosInscripcion = informeComunicarDGSFP2.getDatosInscripcion();
		ArrayList<P06B61T00Datatype> empresasVinculadas = informeComunicarDGSFP2.getEmpresasVinculadas();
		ArrayList<P06B26T00Datatype> atencionCliente = informeComunicarDGSFP2.getAtencionCliente();
		ArrayList<P06B29T00Datatype> defensaCliente = informeComunicarDGSFP2.getDefensaCliente();
		ArrayList<P06B22T00Datatype> socios = informeComunicarDGSFP2.getSocios();
		ArrayList<P06B24T00Datatype> altosCargos = informeComunicarDGSFP2.getAltosCargos();
		try {			
			//create a new file
			FileOutputStream out = new FileOutputStream(excelFichero);
			//create a new workbook
			FileInputStream inputStream = new FileInputStream(new File(P06BParametros.get("excel.comunicarDGSFP2")));
			XSSFWorkbook wb = new XSSFWorkbook(inputStream);
			XSSFSheet s = null;
			XSSFRow r = null;
			XSSFCell c = null;
			XSSFCellStyle cs = null;

			//	Datos Inscripcin
			s = wb.getSheetAt(0);
			byte columns = 13;
			byte posColumnaInicial = 0;

			for(int i=0;i<2;i++){
				r = s.getRow(i);
				for(int j=0;j<columns;j++){
					switch(((i+1) * 100)+j+1){
						case 101: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f1_01"));
							break;
						}
						case 201: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_01"));
							break;
						}
						case 202: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_02"));
							break;
						}
						case 203: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_03"));
							break;
						}
						case 204: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_04"));
							break;
						}
						case 205: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_05"));
							break;
						}
						case 206: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_06"));
							break;
						}
						case 207: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_07"));
							break;
						}
						case 208: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_08"));
							break;
						}
						case 209: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_09"));
							break;
						}
						case 210: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_10"));
							break;
						}
						case 211: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_11"));
							break;
						}
						case 212: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_12"));
							break;
						}
						case 213: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t1f2_13"));
							break;
						}
					}
				}
			}

			int lineaDetalle = 2;
			
			P06B20T00Datatype p06B20T00Datatype = null;

			for(int i=0;i<datosInscripcion.size();i++){
				p06B20T00Datatype = datosInscripcion.get(i);
				
				r = s.getRow(lineaDetalle);
				if (r==null){
					r=s.createRow(lineaDetalle);						
				}
				for(int columnaAVolcar = 0;columnaAVolcar<columns;columnaAVolcar++){
					c = r.getCell(columnaAVolcar);
		            if (c==null){
		            	c = r.createCell(columnaAVolcar);
		            	cs = wb.createCellStyle();
		            	if (columnaAVolcar==7){
			            	cs.setWrapText(true);		            		
		            	}
		            }else{
			            cs = c.getCellStyle();
		            }
		            if (lineaDetalle==2){
						cs.setBorderTop(XSSFCellStyle.BORDER_MEDIUM);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }else if (lineaDetalle==datosInscripcion.size()+1){
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_MEDIUM);
					}else{
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }
		            
		            c.setCellStyle(cs);		        					            	

					switch(columnaAVolcar+1){
						case 1: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_MEDIUM);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B20T00Datatype.getExpedi());
							break;
						}
						case 2: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B20T00Datatype.getFechaAl());
							break;
						}
						case 3: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B20T00Datatype.getFechaBaj());
							break;
						}
						case 4: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B20T00Datatype.getDni());
							break;
						}
						case 5: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B20T00Datatype.getNombre());
							break;
						}
						case 6: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_MEDIUM);
				            c.setCellValue("A");
							break;
						}
						case 7: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B20T00Datatype.getClase());
							break;
						}
						case 8: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B20T00Datatype.getDomici());
							break;
						}
						case 9: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B20T00Datatype.getCodpst());
							break;
						}
						case 10: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue("724");
							break;
						}
						case 11: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B20T00Datatype.getCodpro());
							break;
						}
						case 12: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B20T00Datatype.getCodmun());
							break;
						}
						case 13: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_MEDIUM);
				            c.setCellValue(p06B20T00Datatype.getWeb());
							break;
						}
					}
				}
				lineaDetalle++;
			}				
			
			//	Contratos_y_LPS_o_DE
			s = wb.getSheetAt(1);
			columns = 3;

			for(int i=0;i<2;i++){
				r = s.getRow(i);
				for(int j=0;j<columns;j++){
					switch(((i+1) * 100)+j+1){
						case 101: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t2f1_01"));
							break;
						}
						case 201: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t2f2_01"));
							break;
						}
						case 202: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t2f2_02"));
							break;
						}
						case 203: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t2f2_03"));
							break;
						}
					}
				}
			}

			lineaDetalle = 2;
			
			P06B61T00Datatype p06B61T00Datatype = null;

			for(int i=0;i<empresasVinculadas.size();i++){
				p06B61T00Datatype = empresasVinculadas.get(i);
				
				r = s.getRow(lineaDetalle);
				if (r==null){
					r=s.createRow(lineaDetalle);						
				}
				for(int columnaAVolcar = 0;columnaAVolcar<columns;columnaAVolcar++){
					c = r.getCell(columnaAVolcar);
		            if (c==null){
		            	c = r.createCell(columnaAVolcar);
		            	cs = wb.createCellStyle();
		            }else{
			            cs = c.getCellStyle();
		            }
		            if (lineaDetalle==2){
						cs.setBorderTop(XSSFCellStyle.BORDER_MEDIUM);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }else if (lineaDetalle==empresasVinculadas.size()+1){
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_MEDIUM);
					}else{
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }
		            
		            c.setCellStyle(cs);		        					            	

					switch(columnaAVolcar+1){
						case 1: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_MEDIUM);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B61T00Datatype.getExpedi());
							break;
						}
						case 2: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B61T00Datatype.getClavecat());
							break;
						}
						case 3: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_MEDIUM);
				            c.setCellValue(p06B61T00Datatype.getEntidad());
							break;
						}
					}
				}
				lineaDetalle++;
			}				
			
			//	Atencin Cliente
			s = wb.getSheetAt(2);
			columns = 4;

			for(int i=0;i<2;i++){
				r = s.getRow(i);
				for(int j=0;j<columns;j++){
					switch(((i+1) * 100)+j+1){
						case 101: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t3f1_01"));
							break;
						}
						case 201: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t3f2_01"));
							break;
						}
						case 202: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t3f2_02"));
							break;
						}
						case 203: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t3f2_03"));
							break;
						}
						case 204: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t3f2_04"));
							break;
						}
					}
				}
			}

			lineaDetalle = 2;
			
			P06B26T00Datatype p06B26T00Datatype = null;

			for(int i=0;i<atencionCliente.size();i++){
				p06B26T00Datatype = atencionCliente.get(i);
				
				r = s.getRow(lineaDetalle);
				if (r==null){
					r=s.createRow(lineaDetalle);						
				}
				for(int columnaAVolcar = 0;columnaAVolcar<columns;columnaAVolcar++){
					c = r.getCell(columnaAVolcar);
		            if (c==null){
		            	c = r.createCell(columnaAVolcar);
		            	cs = wb.createCellStyle();
		            }else{
			            cs = c.getCellStyle();
		            }
		            if (lineaDetalle==2){
						cs.setBorderTop(XSSFCellStyle.BORDER_MEDIUM);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }else if (lineaDetalle==atencionCliente.size()+1){
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_MEDIUM);
					}else{
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }
		            
		            c.setCellStyle(cs);		        					            	

					switch(columnaAVolcar+1){
						case 1: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_MEDIUM);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B26T00Datatype.getNumExp());
							break;
						}
						case 2: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B26T00Datatype.getDenominacionCompleta());
							break;
						}
						case 3: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B26T00Datatype.getDomici());
							break;
						}
						case 4: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_MEDIUM);
				            c.setCellValue("");
							break;
						}
					}
				}
				lineaDetalle++;
			}				

			//	Defensa Cliente
			s = wb.getSheetAt(2);
			posColumnaInicial = 5;
			columns = (byte) (posColumnaInicial + 4);

			for(int i=0;i<2;i++){
				r = s.getRow(i);
				for(int j=posColumnaInicial;j<columns;j++){
					switch(((i+1) * 100)+j+1){
						case 106: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t4f1_01"));
							break;
						}
						case 206: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t4f2_01"));
							break;
						}
						case 207: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t4f2_02"));
							break;
						}
						case 208: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t4f2_03"));
							break;
						}
						case 209: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t4f2_04"));
							break;
						}
					}
				}
			}

			lineaDetalle = 2;
			
			P06B29T00Datatype p06B29T00Datatype = null;

			for(int i=0;i<defensaCliente.size();i++){
				p06B29T00Datatype = defensaCliente.get(i);
				
				r = s.getRow(lineaDetalle);
				if (r==null){
					r=s.createRow(lineaDetalle);						
				}
				for(int columnaAVolcar = posColumnaInicial;columnaAVolcar<columns;columnaAVolcar++){
					c = r.getCell(columnaAVolcar);
		            if (c==null){
		            	c = r.createCell(columnaAVolcar);
		            	cs = wb.createCellStyle();
		            }else{
			            cs = c.getCellStyle();
		            }
		            if (lineaDetalle==2){
						cs.setBorderTop(XSSFCellStyle.BORDER_MEDIUM);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }else if (lineaDetalle==defensaCliente.size()+1){
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_MEDIUM);
					}else{
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }
		            
		            c.setCellStyle(cs);		        					            	

					switch(columnaAVolcar+1){
						case 6: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_MEDIUM);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B29T00Datatype.getNumExp());
							break;
						}
						case 7: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B29T00Datatype.getDenominacionCompleta());
							break;
						}
						case 8: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B29T00Datatype.getDomici());
							break;
						}
						case 9: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_MEDIUM);
				            c.setCellValue("");
							break;
						}
					}
				}
				lineaDetalle++;
			}				

			//	Socios
			s = wb.getSheetAt(3);
			columns = 6;

			for(int i=0;i<2;i++){
				r = s.getRow(i);
				for(int j=0;j<columns;j++){
					switch(((i+1) * 100)+j+1){
						case 101: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t5f1_01"));
							break;
						}
						case 201: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t5f2_01"));
							break;
						}
						case 202: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t5f2_02"));
							break;
						}
						case 203: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t5f2_03"));
							break;
						}
						case 204: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t5f2_04"));
							break;
						}
						case 205: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t5f2_05"));
							break;
						}
						case 206: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t5f2_06"));
							break;
						}
					}
				}
			}

			lineaDetalle = 2;
			
			P06B22T00Datatype p06B22T00Datatype = null;

			for(int i=0;i<socios.size();i++){
				p06B22T00Datatype = socios.get(i);
				
				r = s.getRow(lineaDetalle);
				if (r==null){
					r=s.createRow(lineaDetalle);						
				}
				for(int columnaAVolcar = 0;columnaAVolcar<columns;columnaAVolcar++){
					c = r.getCell(columnaAVolcar);
		            if (c==null){
		            	c = r.createCell(columnaAVolcar);
		            	cs = wb.createCellStyle();
		            }else{
			            cs = c.getCellStyle();
		            }
		            if (lineaDetalle==2){
						cs.setBorderTop(XSSFCellStyle.BORDER_MEDIUM);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }else if (lineaDetalle==socios.size()+1){
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_MEDIUM);
					}else{
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }
		            
		            c.setCellStyle(cs);		        					            	

					switch(columnaAVolcar+1){
						case 1: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_MEDIUM);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B22T00Datatype.getNExpediente());
							break;
						}
						case 2: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B22T00Datatype.getIdentificador());
							break;
						}
						case 3: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B22T00Datatype.getDenominacionCompleta());
							break;
						}
						case 4: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B22T00Datatype.getParticipa());
							break;
						}
						case 5: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B22T00Datatype.getFecAlta());
							break;
						}
						case 6: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_MEDIUM);
				            c.setCellValue(p06B22T00Datatype.getFecBaja());
							break;
						}
					}
				}
				lineaDetalle++;
			}				

			//	Altos Cargos
			s = wb.getSheetAt(4);
			columns = 6;

			for(int i=0;i<2;i++){
				r = s.getRow(i);
				for(int j=0;j<columns;j++){
					switch(((i+1) * 100)+j+1){
						case 101: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t6f1_01"));
							break;
						}
						case 201: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t6f2_01"));
							break;
						}
						case 202: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t6f2_02"));
							break;
						}
						case 203: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t6f2_03"));
							break;
						}
						case 204: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t6f2_04"));
							break;
						}
						case 205: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t6f2_05"));
							break;
						}
						case 206: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel03.t6f2_06"));
							break;
						}
					}
				}
			}

			lineaDetalle = 2;
			
			P06B24T00Datatype p06B24T00Datatype = null;

			for(int i=0;i<altosCargos.size();i++){
				p06B24T00Datatype = altosCargos.get(i);
				
				r = s.getRow(lineaDetalle);
				if (r==null){
					r=s.createRow(lineaDetalle);						
				}
				for(int columnaAVolcar = 0;columnaAVolcar<columns;columnaAVolcar++){
					c = r.getCell(columnaAVolcar);
		            if (c==null){
		            	c = r.createCell(columnaAVolcar);
		            	cs = wb.createCellStyle();
		            }else{
			            cs = c.getCellStyle();
		            }
		            if (lineaDetalle==2){
						cs.setBorderTop(XSSFCellStyle.BORDER_MEDIUM);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }else if (lineaDetalle==altosCargos.size()+1){
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_MEDIUM);
					}else{
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }
		            
		            c.setCellStyle(cs);		        					            	

					switch(columnaAVolcar+1){
						case 1: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_MEDIUM);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B24T00Datatype.getnExpediente());
							break;
						}
						case 2: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B24T00Datatype.getIdentificador());
							break;
						}
						case 3: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B24T00Datatype.getDenominacionCompleta());
							break;
						}
						case 4: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B24T00Datatype.getIdCargo());
//				            c.setCellValue(p06B24T00Datatype.getIdCargo() + ".- " + res.get(p06B24T00Datatype.getCargoVisible()));
							break;
						}
						case 5: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B24T00Datatype.getFechNom());
							break;
						}
						case 6: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_MEDIUM);
				            c.setCellValue(p06B24T00Datatype.getFecCese());
							break;
						}
					}
				}
				lineaDetalle++;
			}				

			wb.write(out);
			out.close();
			
		}catch(Exception e) {
			P06BLog.send(2,"P06BListadoExcel", "Error al generar excel:"+e.getMessage());
			return error;
		}
		return excelFichero;
	}
}